Ext.data.JsonP.sol_common_ix_services_GetConfig({"tagname":"class","name":"sol.common.ix.services.GetConfig","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.services.GetConfig.js","href":"sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig"}],"author":[{"tagname":"author","name":"NM, ELO Digital Office GmbH","email":null}],"version":["1.05.000"],"eloix":true,"requires":["sol.common.Config","sol.common.RepoUtils","sol.common.ix.ServiceBase"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.ServiceBase","mixins":[],"uses":[],"members":[{"name":"compose","tagname":"cfg","owner":"sol.common.ix.services.GetConfig","id":"cfg-compose","meta":{}},{"name":"content","tagname":"cfg","owner":"sol.common.ix.services.GetConfig","id":"cfg-content","meta":{}},{"name":"exceptionOnBrokenConfig","tagname":"cfg","owner":"sol.common.ix.services.GetConfig","id":"cfg-exceptionOnBrokenConfig","meta":{}},{"name":"forceReload","tagname":"cfg","owner":"sol.common.ix.services.GetConfig","id":"cfg-forceReload","meta":{}},{"name":"hierarchical","tagname":"cfg","owner":"sol.common.ix.services.GetConfig","id":"cfg-hierarchical","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.services.GetConfig","id":"cfg-objId","meta":{}},{"name":"paths","tagname":"cfg","owner":"sol.common.ix.services.GetConfig","id":"cfg-paths","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"data","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-data","meta":{}},{"name":"logger","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"checkMandatoryProperties","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-checkMandatoryProperties","meta":{"protected":true}},{"name":"containsClassName","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-containsClassName","meta":{}},{"name":"determineMode","tagname":"method","owner":"sol.common.ix.services.GetConfig","id":"method-determineMode","meta":{"private":true}},{"name":"getExplodedConfig","tagname":"method","owner":"sol.common.ix.services.GetConfig","id":"method-getExplodedConfig","meta":{"private":true}},{"name":"getMergedConfig","tagname":"method","owner":"sol.common.ix.services.GetConfig","id":"method-getMergedConfig","meta":{"private":true}},{"name":"getMultipleExplodedConfigs","tagname":"method","owner":"sol.common.ix.services.GetConfig","id":"method-getMultipleExplodedConfigs","meta":{"private":true}},{"name":"getSimpleConfig","tagname":"method","owner":"sol.common.ix.services.GetConfig","id":"method-getSimpleConfig","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-initialize","meta":{"private":true}},{"name":"prefillMetadata","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-prefillMetadata","meta":{"protected":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.services.GetConfig","id":"method-process","meta":{}},{"name":"RF_sol_common_service_GetConfig","tagname":"method","owner":"sol.common.ix.services.GetConfig","id":"static-method-RF_sol_common_service_GetConfig","meta":{"static":true}},{"name":"RF_sol_common_service_GetConfigHierarchies","tagname":"method","owner":"sol.common.ix.services.GetConfig","id":"static-method-RF_sol_common_service_GetConfigHierarchies","meta":{"static":true}},{"name":"RF_sol_common_service_GetConfigHierarchy","tagname":"method","owner":"sol.common.ix.services.GetConfig","id":"static-method-RF_sol_common_service_GetConfigHierarchy","meta":{"static":true}},{"name":"RF_sol_common_service_GetMergedConfig","tagname":"method","owner":"sol.common.ix.services.GetConfig","id":"static-method-RF_sol_common_service_GetMergedConfig","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.services.GetConfig","short_doc":"Returns content of a configuration json file that is stored in ELO. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.ServiceBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a><div class='subclass '><strong>sol.common.ix.services.GetConfig</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig' target='_blank'>sol.common.ix.services.GetConfig.js</a></div></pre><div class='doc-contents'><p>Returns content of a configuration json file that is stored in ELO.</p>\n\n<p>This service is useful if information should be retrieved within external web applications.</p>\n\n<h1>Simple configuration</h1>\n\n<p>This loads a configuration from a single JSON configuration file.</p>\n\n<p>As IX service call</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_sol_common_service_GetConfig', {\n  objId: \"ARCPATH:/Administration/Business Solutions/pubsec/Configuration/pubsec.Config\",\n  forceReload: true  // optional, if true, the cache will be refreshed\n});\n</code></pre>\n\n<p>Returns content of the configuration as followed:</p>\n\n<pre><code>{\n  config: {\n    // config content\n    version: '9.00.001',\n    ruleSetName: \"MY_RULE\",\n    ...\n  }\n}\n</code></pre>\n\n<h1>Merged configuration</h1>\n\n<p>This loads a merged configuration from a hierarchy of JSON configuration files.</p>\n\n<p>As IX service call</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_sol_common_service_GetMergedConfig', {\n  compose: \"ARCPATH:/Administration/Business Solutions/pubsec/Configuration/pubsec.Config\"\n  forceReload: true  // optional, if true, the cache will be refreshed\n});\n</code></pre>\n\n<p>Returns content of the configuration as followed:</p>\n\n<pre><code>{\n  config: {\n    // config content\n    version: '9.00.001',\n    ruleSetName: \"MY_CUSTOM_RULE\",\n    ...\n  }\n}\n</code></pre>\n\n<h1>Configuration hierarchy</h1>\n\n<p>This loads all JSON configuration files from the merge hierarchy, without performing the merge.\nBy default, this just returns the GUIDs.</p>\n\n<p>As IX service call</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_sol_common_service_GetConfigHierarchy', {\n  compose: \"/pubsec/Configuration/pubsec.Config\",\n  content: true  //optional, if not set, or none `true` value, only GUIDs will be returned\n  forceReload: true  // optional, if true, the cache will be refreshed\n});\n</code></pre>\n\n<p>Returns the hierarchy of the configuration as followed:</p>\n\n<pre><code>{\n  defaultConfig: {\n    guid: \"(3A348D43-2C82-CA21-4812-1A10AB368125)\",\n    content: { ... } // opional, only returned, if content parameter was `true`\n  },\n  customConfigs: [\n    { guid: \"(BA8C4F65-7DFA-5F02-23C1-3680A4E8A94E)\", content: { ... } },\n    ...\n  ]\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.05.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-compose' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-cfg-compose' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-cfg-compose' class='name expandable'>compose</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) A relative path inside the 'Business Solutions' (or its 'Custom') folders or even an objId. ...</div><div class='long'><p>(optional) A relative path inside the 'Business Solutions' (or its 'Custom') folders or even an objId. The config will be loaded composed.</p>\n</div></div></div><div id='cfg-content' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-cfg-content' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-cfg-content' class='name expandable'>content</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) If true the hierarchical result will contain the configs themself. ...</div><div class='long'><p>(optional) If <code>true</code> the hierarchical result will contain the configs themself. Only works with <a href=\"#!/api/sol.common.ix.services.GetConfig-cfg-compose\" rel=\"sol.common.ix.services.GetConfig-cfg-compose\" class=\"docClass\">compose</a> and <a href=\"#!/api/sol.common.ix.services.GetConfig-cfg-hierarchical\" rel=\"sol.common.ix.services.GetConfig-cfg-hierarchical\" class=\"docClass\">hierarchical</a>.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-exceptionOnBrokenConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-cfg-exceptionOnBrokenConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-cfg-exceptionOnBrokenConfig' class='name expandable'>exceptionOnBrokenConfig</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nIf true there will be an exception, if one of the merged configs has errors. ...</div><div class='long'><p>(optional)\nIf <code>true</code> there will be an exception, if one of the merged configs has errors.\nThe function <a href=\"#!/api/sol.common.ix.services.GetConfig-static-method-RF_sol_common_service_GetMergedConfig\" rel=\"sol.common.ix.services.GetConfig-static-method-RF_sol_common_service_GetMergedConfig\" class=\"docClass\">RF_sol_common_service_GetMergedConfig</a> overrides the default value always with <code>true</code>, except the call specifies the parameter as <code>false</code>.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-forceReload' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-cfg-forceReload' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-cfg-forceReload' class='name expandable'>forceReload</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) If true cache will be refreshed. ...</div><div class='long'><p>(optional) If <code>true</code> cache will be refreshed.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-hierarchical' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-cfg-hierarchical' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-cfg-hierarchical' class='name expandable'>hierarchical</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) If true the result will contain all GUIDs of configurations which would be part of the merging. ...</div><div class='long'><p>(optional) If <code>true</code> the result will contain all GUIDs of configurations which would be part of the merging. Only works with <a href=\"#!/api/sol.common.ix.services.GetConfig-cfg-compose\" rel=\"sol.common.ix.services.GetConfig-cfg-compose\" class=\"docClass\">compose</a>.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-objId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) The object id of the configuration (also guid and arcpath allowed). ...</div><div class='long'><p>(optional) The object id of the configuration (also guid and arcpath allowed). The config will be loaded plain.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-cfg-objId\" rel=\"sol.common.ix.ServiceBase-cfg-objId\" class=\"docClass\">sol.common.ix.ServiceBase.objId</a></p></div></div></div><div id='cfg-paths' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-cfg-paths' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-cfg-paths' class='name expandable'>paths</a> : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) an array of relative paths inside the 'Business Solutions' (or its 'Custom') folders or even an objId. ...</div><div class='long'><p>(optional) an array of relative paths inside the 'Business Solutions' (or its 'Custom') folders or even an objId. The configs will be loaded composed.</p>\n        <p>Available since: <b>1.05.000</b></p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-data' class='name expandable'>data</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div><div class='long'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the service</p>\n</div><div class='long'><p>The logger for the service</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-checkMandatoryProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-checkMandatoryProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-checkMandatoryProperties' class='name expandable'>checkMandatoryProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Checks if all mandatory properties have been set. ...</div><div class='long'><p>Checks if all mandatory properties have been set.</p>\n</div></div></div><div id='method-containsClassName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-containsClassName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-containsClassName' class='name expandable'>containsClassName</a>( <span class='pre'>classNames</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether an array contains the class name ...</div><div class='long'><p>Checks wether an array contains the class name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classNames</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-determineMode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-method-determineMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-method-determineMode' class='name expandable'>determineMode</a>( <span class='pre'></span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Determines in which mode the class is executed (\"SIMPLE\"|\"MERGED\"|\"HIERARCHICAL\"). ...</div><div class='long'><p>Determines in which mode the class is executed (\"SIMPLE\"|\"MERGED\"|\"HIERARCHICAL\").</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getExplodedConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-method-getExplodedConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-method-getExplodedConfig' class='name expandable'>getExplodedConfig</a>( <span class='pre'>compose</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves a simple configuration from an objId ...</div><div class='long'><p>Retrieves a simple configuration from an objId</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>compose</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getMergedConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-method-getMergedConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-method-getMergedConfig' class='name expandable'>getMergedConfig</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves a merged configuration from an objId or a path ...</div><div class='long'><p>Retrieves a merged configuration from an objId or a path</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getMultipleExplodedConfigs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-method-getMultipleExplodedConfigs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-method-getMultipleExplodedConfigs' class='name expandable'>getMultipleExplodedConfigs</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves multiple simple configuration from an objId. ...</div><div class='long'><p>Retrieves multiple simple configuration from an objId.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSimpleConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-method-getSimpleConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-method-getSimpleConfig' class='name expandable'>getSimpleConfig</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves a simple configuration from an objId ...</div><div class='long'><p>Retrieves a simple configuration from an objId</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-prefillMetadata' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-prefillMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-prefillMetadata' class='name expandable'>prefillMetadata</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Initializes the metadata of an element (defined by objId) from the internal data object. ...</div><div class='long'><p>Initializes the metadata of an element (defined by <code>objId</code>) from the internal <code>data</code> object.</p>\n\n<p>The <code>data</code> property has to be in a specific <a href=\"#!/api/sol.common.ix.ServiceBase-property-data\" rel=\"sol.common.ix.ServiceBase-property-data\" class=\"docClass\">form</a>.\nIf there is no data object no prefilling will be performed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-method-process' class='name expandable'>process</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Downloads the given file content as string ...</div><div class='long'><p>Downloads the given file content as string</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-method-process\" rel=\"sol.common.ix.ServiceBase-method-process\" class=\"docClass\">sol.common.ix.ServiceBase.process</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_common_service_GetConfig' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-static-method-RF_sol_common_service_GetConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-static-method-RF_sol_common_service_GetConfig' class='name expandable'>RF_sol_common_service_GetConfig</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_common_service_GetConfigHierarchies' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-static-method-RF_sol_common_service_GetConfigHierarchies' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-static-method-RF_sol_common_service_GetConfigHierarchies' class='name expandable'>RF_sol_common_service_GetConfigHierarchies</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n        <p>Available since: <b>1.05.000</b></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_common_service_GetConfigHierarchy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-static-method-RF_sol_common_service_GetConfigHierarchy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-static-method-RF_sol_common_service_GetConfigHierarchy' class='name expandable'>RF_sol_common_service_GetConfigHierarchy</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_common_service_GetMergedConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetConfig'>sol.common.ix.services.GetConfig</span><br/><a href='source/sol.common.ix.services.GetConfig.html#sol-common-ix-services-GetConfig-static-method-RF_sol_common_service_GetMergedConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetConfig-static-method-RF_sol_common_service_GetMergedConfig' class='name expandable'>RF_sol_common_service_GetMergedConfig</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});